// config: norepeat

#include "GetObjects.js"
#include "EditOrientations.js"

function DoLoft()
{
	var objectpicker = moi.ui.createObjectPicker();
	objectpicker.allowCurves();
	objectpicker.allowPointObjects();
	objectpicker.min = 2;
	
	if ( !GetObjects( objectpicker ) )
		return;

	var factory = moi.command.createFactory( 'loft' );

	var curves = objectpicker.objects;
	if ( curves.numCurves == 0 )
		return; // Only had points, not any curves.
	
	moi.geometryDatabase.sortCurves( curves );
	factory.setInput( 0, curves );

	moi.ui.beginUIUpdate();
	moi.ui.hideUI( 'SelectionPrompt' );
	moi.ui.showUI( 'LoftPrompt' );
	moi.ui.showUI( 'LoftOptions' );
	
	if ( !factory.canHaveCaps )
		moi.ui.hideUI( 'capends' );
		
	if ( curves.length < 3 )
		moi.ui.hideUI( 'closedcheckbox' );
	
	moi.ui.endUIUpdate();

	factory.disableUpdate( true );
	moi.ui.bindUIToInput( 'loftstyle', 'value', factory.getInput(2) );	
	moi.ui.bindUIToInput( 'capends', 'value', factory.getInput(3) );
	moi.ui.bindUIToInput( 'closedcheckbox', 'value', factory.getInput(4) );
	moi.ui.bindUIToInput( 'profiles', 'value', factory.getInput(5) );
	moi.ui.bindUIToInput( 'profilesnumpoints', 'value', factory.getInput(6) );
	factory.disableUpdate( false );
	factory.update();
	
	if ( !EditOrientations( curves, factory, 1 ) )
		return;
		
	factory.commit();
}

DoLoft();
